#include "DList.h"

// SE : Contructeur de BaseList
BaseList::BaseList()
 { premier = dernier = courant = last_index = 0;
   nbre_elt = last_acces = 0;
 }
BaseList::~BaseList()
 { purge();
 }


//     ---> BaseList::purge()
//
// SE : supprime tous les elements de la liste

void BaseList::purge()
 { courant = premier;
   while (courant)
    { premier = courant;
      courant = courant->next;
      delete premier;
    }
   premier = dernier = courant = last_index = 0;
   nbre_elt = last_acces = 0;
 }

//     ---> BaseList::insert(Link*)
//
// SE : ajoute un element en debut de liste
void BaseList::insert (Link *l)
 { if (premier == 0)
      last_index = dernier = premier = l;
   else
     { l->next = premier;
       premier->previous = l;
       premier = courant = l;
       last_index = last_index->previous;   // car on en ajoute un en tete
     }
   nbre_elt++;
 }
//     ---> BaseList::append(Link*)
//
// SE : ajoute un element en fin de liste

void BaseList::append(Link *l)
 { if ( premier == 0)
      last_index = courant = premier = dernier = l;       // premier elt add dans la liste
   else
    { dernier->next = l;
      l->previous = dernier;
      dernier = l;
    }
   nbre_elt++;
 }
//     ---> BaseList::insertAt()
//
// SE : ajoute un element dans la liste  la position p
//      et rinitialise le Parcour
void BaseList::insertAt(Link *l,unsigned p)
 { if (p == 0)
      insert(l);
   else
	 { if (p == nbre_elt)
			append(l);
      else
       { if (p < nbre_elt)
          { Link *tmp = (*this)[p-1];
            if (tmp != 0)
             { l->next = tmp->next;
               tmp->next->previous = l;
               tmp->next = l;
               l->previous = tmp;
               nbre_elt++;
               courant = last_index = premier;
               last_acces = 0;
             }
          }
       }
    }
 }
//    -----> BaseList::removeAt
//
// SE : supprime l'elt place a la position specifier
//      repositionne l'iteration au debut de la liste
int BaseList::removeAt(unsigned position)
 { Link   *tmp;

   if (nbreElt() < position+1)
      return END_OF_LIST;
   if (position==0)            // suppression du premier
    { tmp=premier;
      premier = premier->next;
      if (premier != 0)       // si la liste comprenait plus d'un elt
         premier->previous = 0;
      else
         dernier = 0;
    }
   else
    { if (position==nbreElt()-1)  // suppression du dernier
       { tmp = dernier;
         dernier = dernier->previous;
	 dernier->next = 0;
       }
      else                       // suppression d'un elt quelconque
       { tmp = premier;
         for (int i=0;i < position;i++)
	    tmp = tmp->next;
	 courant = tmp->previous;
	 courant->next = tmp->next;
	 courant->next->previous = courant;
       }
    }
   tmp->next = 0;       // pour le detruire sans detruire le reste de la liste
   delete tmp;
   courant = last_index = premier;
   last_acces = 0;
   nbre_elt--;
   return ELT_OK;
 }



//     ---> BaseList::getNext()
//
// SE : retourne le prochain elt de la liste et se positionne sur le suivant

Link *BaseList::getNext()
 { Link *tmp = courant;

   if (courant != 0)
      courant = (tmp = courant)->next;
   return tmp;
 }

//     ---> BaseList::getPrevious()
//
// SE : retourne le prochain elt de la liste et se positionne sur le precedent
Link *BaseList::getPrevious()
 { Link *tmp = courant;

   if (courant != 0)
      courant = (tmp = courant)->previous;
   return tmp;
 }

//     ---> BaseList::operator [](int i)
//
//   SE : retourne le i-ieme elt de la liste
//   SI : on se sert de last_acces et last_index pour optimiser
Link *BaseList::operator[] (unsigned i)
 { if (premier==0 || i >= nbre_elt)
      return 0;
   if (last_acces == i)
      return last_index;
   if (last_acces - i == 1)        // elt precedent le dernier accede
    { last_acces --;
      return last_index = last_index->previous;
    }
   if (i - last_acces == 1)        // elt suivant le dernier accede
    { last_acces++;
      return last_index = last_index->next;
    }
   if (i > last_acces)
      do
         last_index = last_index->next;
      while (++last_acces != i);
   else
      do
         last_index = last_index->previous;
      while (--last_acces != i);
   return last_index;

 }

